using gov.va.med.vbecs.Common;
using System;
using System.Linq;
using System.Collections.Generic;

namespace gov.va.med.vbecs.BOL
{
    /// <summary>
    /// PendingTestModel
    /// </summary>
    public abstract class PendingTestModel : IPendingTestModel
    {
        /// <summary>
        /// TestedDateTime
        /// </summary>
        public DateTime TestedDateTime { get; set; }
        /// <summary>
        /// InstrumentName
        /// </summary>
        public string InstrumentName { get; set; }
        /// <summary>
        /// InstrumentUserId
        /// </summary>
        public string InstrumentUserId { get; set; }
        /// <summary>
        /// InstrumentUserName
        /// </summary>
        public string InstrumentUserName { get; set; }
        /// <summary>
        /// AutoInstrumentComments
        /// </summary>
        public string AutoInstrumentComments { get; set; }
        /// <summary>
        /// PendingTestStatus
        /// </summary>
        public PendingTestStatus PendingTestStatus { get; set; }
        /// <summary>
        /// ReviewComment
        /// </summary>
        public string ReviewComment { get; set; }
        /// <summary>
        /// DivisionCode
        /// </summary>
        public string DivisionCode { get; set; }
        /// <summary>
        /// OrderableTestModel
        /// </summary>
        public OrderableTestModel OrderableTest { get; set; }
        /// <summary>
        /// TestValidationModel
        /// </summary>
        public TestValidationModel TestValidation { get; set; }
        /// <summary>
        /// TestResultList
        /// </summary>
        public IList<PendingTestResultModel> TestResultList { get; set; }
        /// <summary>
        /// LastUpdateUser
        /// </summary>
        public string LastUpdateUser { get; set; }
        /// <summary>
        /// InterpText
        /// </summary>
        public abstract string InterpText { get; }
        /// <summary>
        /// WorkloadProcessID
        /// </summary>
        public abstract WorkloadProcessID WorkloadProcessId { get; }

        /// <summary>
        /// Constructor
        /// </summary>
        public PendingTestModel()
        {
            TestResultList = new List<PendingTestResultModel>();
        }

        /// <summary>
        /// Get pending test result for given blood test type. If not found return a PendingTestHelper.NOT_TESTED_SYMBOL object
        /// </summary>
        /// <param name="bloodTestType"></param>
        /// <param name="returnNullIfNotFound"></param>
        public PendingTestResultModel GetPendingTestResult(TestType bloodTestType, bool returnNullIfNotFound)
        {
            var result = TestResultList.FirstOrDefault(x => x.TestType == bloodTestType);
            if (!returnNullIfNotFound &&
                result == null)
            {
                result = new PendingTestResultModel(0, bloodTestType, "", PendingTestHelper.NOT_TESTED_SYMBOL, PendingTestHelper.NOT_TESTED_SYMBOL, null);
            }

            return result;
        }

        /// <summary>
        /// Get pending test result for given blood test type list. If not found return a PendingTestHelper.NOT_TESTED_SYMBOL object
        /// </summary>
        /// <param name="typeTypeList"></param>
        /// <param name="returnNullIfNotFound"></param>
        public PendingTestResultModel GetPendingTestResult(List<TestType> typeTypeList, bool returnNullIfNotFound)
        {
            var result = TestResultList.FirstOrDefault(x => typeTypeList.Contains(x.TestType));

            if (!returnNullIfNotFound &&
                result == null)
            {
                result = new PendingTestResultModel(0, TestType.Unknown, "", PendingTestHelper.NOT_TESTED_SYMBOL, PendingTestHelper.NOT_TESTED_SYMBOL, null);
            }

            return result;
        }
    }
}



